/**
 * @brief Complex Object demo (Mode 2)
 * @author Thomas Cherryhomes
 * @email thom dot cherryhomes at gmail dot com
 * @license gpl v. 3, see COPYING for details
 */

#ifndef SOUND_DATA_AREA_H
#define SOUND_DATA_AREA_H

// 32nd notes (used for trill) take 4 frames
// sixteenth notes take 8 frames
// eighth dot notes take 24 frames
// eighth notes take 16 frames
// quarter notes take 48 frames

unsigned char output0[10], output1[10], output2[10], output3[10];

const unsigned char sound0[] =
  {
    // measure 1, 16th notes, notes are in octave above middle C, at full volume.
    0x40, 0xbe, 0x00, 0x08, // D
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x78, 0x00, 0x08, // Ab

    // measure 2, also 16th notes, a reflection of the previous measure.
    0x40, 0xc9, 0x00, 0x08, // Db
    0x40, 0x78, 0x00, 0x08, // Ab
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0xa9, 0x00, 0x08, // E

    // measure 3, eighth notes
    0x40, 0xa0, 0x00, 0x10, // F
    0x40, 0x7f, 0x00, 0x10, // A
    0x40, 0x5f, 0x00, 0x10, // D

    // measure 4, eighth notes
    0x40, 0x5f, 0x00, 0x10, // G
    0x40, 0x32, 0x00, 0x10, // C#
    0x40, 0x2a, 0x00, 0x10, // E

    // measure 5, sixteenth notes
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x47, 0x00, 0x08, // G 
    0x40, 0x3f, 0x00, 0x08, // A 
    0x40, 0x3c, 0x00, 0x08, // Bb

    // measure 6, sixteenth notes
    0x40, 0xbe, 0x00, 0x08, // C#
    0x40, 0x3c, 0x00, 0x08, // Bb
    0x40, 0x3f, 0x00, 0x08, // A
    0x40, 0x47, 0x00, 0x08, // G
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x54, 0x00, 0x08, // E   

    // measure 7, sixteenth notes
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x47, 0x00, 0x08, // G 
    0x40, 0x3f, 0x00, 0x08, // A 

    // measure 8, sixteenth notes
    0x40, 0x78, 0x00, 0x08, // Ab
    0x40, 0x1f, 0x00, 0x08, // A
    0x40, 0x23, 0x00, 0x08, // G
    0x40, 0x28, 0x00, 0x08, // F
    0x40, 0x2a, 0x00, 0x08, // E
    0x40, 0x2f, 0x00, 0x08, // D

    // measure 9, sixteenth notes
    0x40, 0x2a, 0x00, 0x08, // E
    0x40, 0xd5, 0x00, 0x08, // C
    0x40, 0x2f, 0x00, 0x08, // D
    0x40, 0x2a, 0x00, 0x08, // E
    0x40, 0x28, 0x00, 0x08, // F
    0x40, 0x23, 0x00, 0x08, // G

    // measure 10, sixteenth notes
    0x40, 0x3f, 0x00, 0x08, // A
    0x40, 0x23, 0x00, 0x08, // G ^
    0x40, 0x25, 0x00, 0x08, // F ^
    0x40, 0x2a, 0x00, 0x08, // E ^
    0x40, 0x2f, 0x00, 0x08, // D ^
    0x40, 0x35, 0x00, 0x08, // C ^

    // Measure 11, sixteenth notes
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x50, 0x00, 0x08, // F

    // Measure 12, 8th note, two 8th rests
    0x40, 0x8e, 0x00, 0x10, // G
    0x70,                   // 8th note rest
    0x70,                   // 8th note rest

    // Measure 13, 16 notes
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E

    // Measure 14, 8th note, 8th rest, 8th note (tied)
    0x40, 0xa0, 0x00, 0x10, // F
    0x70,                   // 8th note rest
    0x40, 0x78, 0x00, 0x10, // Bb

    // Measure 15, 8th notes
    0x40, 0x78, 0x00, 0x10, // Bb
    0x40, 0x7f, 0x00, 0x10, // A
    0x40, 0x8e, 0x00, 0x10, // G

    // Measure 16, 16th notes
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0xa9, 0x00, 0x08, // E

    // Measure 17, 2 16ths, a dotted 8th, and a 16th
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0x8e, 0x00, 0x18, // G (dotted)
    0x40, 0xa0, 0x00, 0x08, // F

    // Measure 18, 8th notes
    0x40, 0xa0, 0x00, 0x10, // F
    0x40, 0x6a, 0x00, 0x10, // C
    0x40, 0x6a, 0x00, 0x10, // C

    // Measure 19, trill
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D

    // Measure 20, trill
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D

    // Measure 21, trill
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D
    0x40, 0x6a, 0x00, 0x04, // C
    0x40, 0x5f, 0x00, 0x04, // D

    // Measure 22, 16th notes
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0xa9, 0x00, 0x08, // E

    // Measure 23, 16th notes
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0xbe, 0x00, 0x08, // D
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0x97, 0x00, 0x08, // F#
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0x7f, 0x00, 0x08, // A

    // Measure 24, 16th notes
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0xbe, 0x00, 0x08, // D

    // Measure 25, 16th notes
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0xd5, 0x00, 0x08, // C
    0x40, 0xbe, 0x00, 0x08, // D
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0x8e, 0x00, 0x08, // G

    // Measure 26, 16th notes
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x71, 0x00, 0x08, // Bn
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x50, 0x00, 0x08, // F

    // Measure 27, 16th notes
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x71, 0x00, 0x08, // Bn

    // Measure 28, 16th notes
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x71, 0x00, 0x08, // Bn
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x71, 0x00, 0x08, // Bn
    0x40, 0x7f, 0x00, 0x08, // A

    // Measure 29, 16th notes
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x97, 0x00, 0x08, // F# 
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0xbe, 0x00, 0x08, // D

    // Measure 30, 16th notes
    0x40, 0xd5, 0x00, 0x08, // C
    0x40, 0xbe, 0x00, 0x08, // D
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0x97, 0x00, 0x08, // F# 
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x7f, 0x00, 0x08, // A

    // Measure 31, 16th notes
    0x40, 0xbe, 0x00, 0x08, // D
    0x40, 0x6a, 0x00, 0x08, // C ^
    0x40, 0x71, 0x00, 0x08, // Bn
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x97, 0x00, 0x08, // F# 

    // Measure 32, 16th notes
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0x97, 0x00, 0x08, // F# 
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x71, 0x00, 0x08, // Bn
    0x40, 0x6a, 0x00, 0x08, // C

    // Measure 33, 16th notes
    0x40, 0x97, 0x00, 0x08, // F# 
    0x40, 0x54, 0x00, 0x08, // E ^
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x71, 0x00, 0x08, // Bn
    0x40, 0x7f, 0x00, 0x08, // A
    
    // Measure 34, 16th notes
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x86, 0x00, 0x08, // G#
    0x40, 0x97, 0x00, 0x08, // F# 
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0xbe, 0x00, 0x08, // D

    // Measure 35, 16th notes
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x71, 0x00, 0x08, // Bn

    // Measure 36, 4 16th notes, 1 8th note
    0x40, 0x3f, 0x00, 0x08, // A
    0x40, 0x43, 0x00, 0x08, // G#
    0x40, 0x4b, 0x00, 0x08, // F#
    0x40, 0x54, 0x00, 0x10, // E

    // Measure 37 2 16ths, dotted 8th, 1 16th
    0x40, 0x3f, 0x00, 0x08, // A
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x71, 0x00, 0x18, // Bn (dotted 8th)
    0x40, 0x7f, 0x00, 0x08, // A

    // Measure 38 Dotted 8th, 3 16ths
    0x40, 0x7f, 0x00, 0x18, // A (dotted 8th)
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0x6a, 0x00, 0x08, // C

    // Measure 39, 8th notes
    0x40, 0xbe, 0x00, 0x10, // D
    0x40, 0x97, 0x00, 0x10, // F#
    0x40, 0x7f, 0x00, 0x10, // A

    // Measure 40, 16th notes
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x5f, 0x00, 0x08, // D

    // Measure 41, 16th notes
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0x5f, 0x00, 0x08, // D ^
    0x40, 0x6a, 0x00, 0x08, // C ^
    0x40, 0x78, 0x00, 0x08, // Bb ^
    0x40, 0x7f, 0x00, 0x08, // A ^
    0x40, 0x8e, 0x00, 0x08, // G ^

    // Measure 42, 8th note, 2 16th notes, 8th note
    0x40, 0x7f, 0x00, 0x10, // A
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x50, 0x00, 0x10, // F

    // Measure 43, 2 8th notes, 8th rest
    0x40, 0x8e, 0x00, 0x10, // G
    0x40, 0x54, 0x00, 0x10, // E ^
    0x70,                   // 8th note rest

    // Measure 44, 16th notes
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x47, 0x00, 0x08, // G
    0x40, 0x3f, 0x00, 0x08, // A
    0x40, 0x3b, 0x00, 0x08, // Bb

    // Measure 45, 16th notes
    0x40, 0x64, 0x00, 0x08, // C#
    0x40, 0x3c, 0x00, 0x08, // Bb ^
    0x40, 0x3f, 0x00, 0x08, // A
    0x40, 0x47, 0x00, 0x08, // G
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x54, 0x00, 0x08, // E

    // Measure 46, 8th notes
    0x40, 0x50, 0x00, 0x10, // F
    0x40, 0x5f, 0x00, 0x10, // D
    0x40, 0x8e, 0x00, 0x10, // G

    // Measure 47, 16th notes
    0x40, 0x8e, 0x00, 0x10, // G
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x64, 0x00, 0x08, // C#
    0x40, 0x54, 0x00, 0x08, // E
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x64, 0x00, 0x08, // C#

    // Measure 48, 2 16th, 1 dotted eighth, 1 16th
    0x40, 0x50, 0x00, 0x08, // F
    0x40, 0x71, 0x00, 0x08, // Bn
    0x40, 0x64, 0x00, 0x18, // C#
    0x40, 0x5f, 0x00, 0x08, // D

    // Measure 49, 16th notes
    0x40, 0x5f, 0x00, 0x08, // D
    0x40, 0x6a, 0x00, 0x08, // C
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x8e, 0x00, 0x08, // G
    0x40, 0xa0, 0x00, 0x08, // F

    // Measure 50, 16th notes
    0x40, 0x78, 0x00, 0x08, // Bb
    0x40, 0xc9, 0x00, 0x08, // C#
    0x40, 0xbe, 0x00, 0x08, // D
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0xa0, 0x00, 0x08, // F
    0x40, 0x8e, 0x00, 0x08, // G

    // Measure 51, 2 16ths, 1 8th, 2 16ths
    0x40, 0x7f, 0x00, 0x08, // A
    0x40, 0x5f, 0x00, 0x08, // D ^
    0x40, 0xa0, 0x00, 0x10, // F 
    0x40, 0xa9, 0x00, 0x08, // E
    0x40, 0xbe, 0x00, 0x08, // D

    // Measure 52 fermata
    0x40, 0xbe, 0x00, 0x30, // D

    
    0xFF, // end of song (so it doesn't go off into the weeds)
  };

const unsigned char sound1[] =
  {
    // Measure 1, rests
    0xa8,
    0xa8,
    0xa8,
    0xa8,
    0xa8,
    0xa8,

    // Measure 2, rests
    0xa8,
    0xa8,
    0xa8,
    0xa8,
    0xa8,
    0xa8,

    // Measure 3, 16th notes, octave above
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0xfe, 0x00, 0x08, // A 
    0x80, 0xf0, 0x00, 0x08, // Bb

    // Measure 4, 16th notes, octave above
    0x80, 0x93, 0x01, 0x08, // C#
    0x80, 0xf0, 0x00, 0x08, // Bb
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x52, 0x01, 0x08, // E

    // Measure 5, 8th notes
    0x80, 0x40, 0x01, 0x10,
    0x80, 0xfe, 0x00, 0x10,
    0x80, 0xbe, 0x00, 0x10,

    // Measure 6, 8th notes
    0x80, 0x54, 0x00, 0x10,
    0x80, 0x1d, 0x01, 0x10,
    0x80, 0x93, 0x01, 0x10,

    // Measure 7, 8th notes
    0x80, 0x7c, 0x01, 0x10, // D
    0x80, 0xfe, 0x00, 0x10, // A 
    0x80, 0x40, 0x01, 0x10, // F

    // Measure 8, 8th notes
    0x80, 0x1d, 0x01, 0x10, // G
    0x80, 0xfe, 0x00, 0x10, // A
    0x80, 0xf0, 0x00, 0x10, // Bb

    // Measure 9, 8th notes
    0x80, 0xaa, 0x01, 0x10, // C
    0x80, 0xd5, 0x00, 0x10, // C ^
    0x80, 0x52, 0x01, 0x10, // E

    // Measure 10, 8th notes
    0x80, 0x40, 0x01, 0x10, // F
    0x80, 0x1d, 0x01, 0x10, // G
    0x80, 0xfe, 0x00, 0x10, // A

    // Measure 11, 16th notes
    0x80, 0xf0, 0x00, 0x08, // Bb
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0xf0, 0x00, 0x08, // Bb
    0x80, 0xd5, 0x00, 0x08, // C
    0x80, 0xbe, 0x00, 0x08, // D

    // Measure 12, 16th notes
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0xbe, 0x00, 0x08, // D ^
    0x80, 0xd5, 0x00, 0x08, // C ^
    0x80, 0xf0, 0x00, 0x08, // Bb ^
    0x80, 0xfe, 0x00, 0x08, // A ^
    0x80, 0x1d, 0x01, 0x08, // G ^

    // Measure 13, 16th notes
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0xf0, 0x00, 0x08, // Bb ^
    0x80, 0xd5, 0x00, 0x08, // C

    // Measure 14, 16th notes
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0xd5, 0x00, 0x08, // C
    0x80, 0xf0, 0x00, 0x08, // Bb
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0x40, 0x01, 0x08, // F
    
    // Measure 15, 16th notes
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0x7d, 0x01, 0x08, // D
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x1d, 0x01, 0x08, // G

    // Measure 16, 16th notes
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0xaa, 0x01, 0x08, // C

    // Measure 17, 2 16ths, 2 8ths
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0xe0, 0x01, 0x08, // Bb
    0x80, 0xaa, 0x01, 0x10, // C
    0x80, 0x55, 0x03, 0x10, // C v

    // Measure 18, 16th notes
    0x80, 0x7f, 0x02, 0x08, // F
    0x80, 0x3a, 0x02, 0x08, // G
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0xe0, 0x01, 0x08, // Bb
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0x7c, 0x01, 0x08, // D

    // Measure 19, 16th notes
    0x80, 0xa5, 0x02, 0x08, // E
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0xe0, 0x01, 0x08, // Bb
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0x3a, 0x02, 0x08, // G

    // Measure 20, 16th notes
    0x80, 0xf8, 0x03, 0x08, // A
    0x80, 0xbc, 0x03, 0x08, // Bb
    0x80, 0x5c, 0x03, 0x08, // C
    0x80, 0xf8, 0x02, 0x08, // D
    0x80, 0xa5, 0x02, 0x08, // E
    0x80, 0x7f, 0x02, 0x08, // F

    // Measure 21, 16th notes
    0x80, 0x3a, 0x02, 0x08, // G
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0xe0, 0x01, 0x08, // Bb

    // Measure 22, 16th notes
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0xc4, 0x01, 0x08, // B
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0xc4, 0x01, 0x08, // B
    0x80, 0xaa, 0x01, 0x08, // C

    // Measure 23, 8th note, two 8th rests
    0x80, 0x5c, 0x02, 0x10, // F#
    0xb0,                   // 8th note rest
    0xb0,                   // 8th note rest

    // Measure 24, 16th notes
    0x80, 0x3a, 0x02, 0x08, // G
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0xe0, 0x01, 0x08, // Bb
    0x80, 0x3a, 0x02, 0x08, // G
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0xe0, 0x01, 0x08, // Bb

    // Measure 25, 8th note, two 8th rests
    0x80, 0xa5, 0x02, 0x08,
    0xb0,                   // 8th note rest
    0xb0,                   // 8th note rest
    
    // Measure 26, 8th notes
    0x80, 0x7f, 0x02, 0x10, // F
    0x80, 0x7d, 0x01, 0x10, // D ^
    0x80, 0xe0, 0x01, 0x10, // Bb

    // Measure 27, 8th notes
    0x80, 0xc4, 0x01, 0x10, // Bn
    0x80, 0x19, 0x02, 0x10, // G#
    0x80, 0xaa, 0x02, 0x10, // E
   
    // Measure 28, 16th notes
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0x1c, 0x02, 0x08, // G#
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0xc4, 0x01, 0x08, // Bn
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0x7c, 0x01, 0x08, // D

    // Measure 29, trills
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F

    // Measure 30, trills
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F

    // Measure 31, trills
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F

    // Measure 32, oh look, more trills
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F

    // Measure 33, the last of the trills
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F
    0x80, 0x54, 0x01, 0x04, // E
    0x80, 0x40, 0x01, 0x04, // F

    // Measure 34, eighth notes
    0x80, 0x54, 0x01, 0x10, // E
    0x80, 0xa9, 0x00, 0x10, // E ^
    0x80, 0xbe, 0x00, 0x10, // D

    // Measure 35, eighth notes
    0x80, 0xaa, 0x01, 0x10, // C
    0x80, 0xc4, 0x01, 0x10, // Bn
    0x80, 0xfc, 0x01, 0x10, // A

    /// Measure 36, eighth notes
    0x80, 0xbe, 0x00, 0x10, // D
    0x80, 0xa9, 0x00, 0x10, // E
    0x80, 0xa0, 0x00, 0x10, // F

    // Measure 37, eighth notes
    0x80, 0xbe, 0x00, 0x10, // D
    0x80, 0xa9, 0x00, 0x10, // E
    0x80, 0x52, 0x01, 0x10, // E v

    // Measure 38, 16th notes
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0xfc, 0x01, 0x08, // A v
    0x80, 0xe0, 0x01, 0x08, // Bb
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0x67, 0x01, 0x08, // Eb

    // Measure 39, 16th notes
    0x80, 0x5c, 0x02, 0x08, // F#
    0x80, 0x67, 0x01, 0x08, // Eb
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0xaa, 0x01, 0x08, // C
    0x80, 0xe0, 0x01, 0x08, // Bb
    0x80, 0xfc, 0x01, 0x08, // A

    // Measure 40, dotted eighth, three 16th notes
    0x80, 0x3a, 0x02, 0x18, // G
    0x80, 0x3a, 0x02, 0x08, // G
    0x80, 0xfc, 0x01, 0x08, // A
    0x80, 0xe0, 0x01, 0x08, // Bb

    // Measure 41, eighth notes
    0x80, 0x55, 0x03, 0x10, // C
    0x80, 0x3a, 0x02, 0x10, // G
    0x80, 0xaa, 0x01, 0x10, // C

    // Measure 42, 16th notes
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0xe2, 0x00, 0x08, // Bn
    0x80, 0xc9, 0x00, 0x08, // C#
    0x80, 0xbe, 0x00, 0x08, // D

    // Measure 43, 16th notes
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0xbe, 0x00, 0x08, // D
    0x80, 0xc9, 0x00, 0x08, // C#
    0x80, 0xe2, 0x00, 0x08, // Bn
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0x1d, 0x01, 0x08, // G

    // Measure 44, 8th notes
    0x80, 0x40, 0x01, 0x10, // F
    0x80, 0xfe, 0x00, 0x10, // A
    0x80, 0xbe, 0x00, 0x10, // D ^

    // Measure 45, 8th notes
    0x80, 0x52, 0x01, 0x10, // E
    0x80, 0x1d, 0x01, 0x10, // G
    0x80, 0xc9, 0x00, 0x10, // C#

    // Measure 46, 16th notes
    0x80, 0x7c, 0x01, 0x08, // D
    0x80, 0x52, 0x01, 0x08, // E
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0xf0, 0x00, 0x08, // Bb

    // Measure 47, 16th notes
    0x80, 0x93, 0x01, 0x08, // C#
    0x80, 0xf0, 0x00, 0x08, // Bb
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x52, 0x01, 0x08, // E

    // Measure 48, 2 16th notes, 2 8th notes
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0xfe, 0x00, 0x10, // A
    0x80, 0xfc, 0x01, 0x10, // A v

    // Measure 49, 1 dotted eight, three 16th notes
    0x80, 0xc4, 0x03, 0x18, // Bb
    0x80, 0x5c, 0x03, 0x08, // C
    0x80, 0xc4, 0x03, 0x08, // Bb
    0x80, 0xf8, 0x03, 0x08, // A

    // Measure 50, 16th notes
    0x80, 0x3a, 0x02, 0x08, // G v
    0x80, 0xf0, 0x00, 0x08, // Bb
    0x80, 0xfe, 0x00, 0x08, // A
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x54, 0x01, 0x08, // E

    // Measure 51, 2 16th notes, 2 8th notes
    0x80, 0x40, 0x01, 0x08, // F
    0x80, 0x1d, 0x01, 0x08, // G
    0x80, 0xfe, 0x00, 0x10, // A
    0x80, 0xfc, 0x01, 0x10,

    // Measure 52, fermata
    0x80, 0xf8, 0x02, 0x30, // D

    
    0xFF, // end of song (so it doesn't go off into the weeds)
  };

const unsigned char sound2[] = {0x00};

const void *soundTable[] = {&sound0,&output0,&sound1,&output1,&sound2,&output2,&sound2,&output3};

#endif /* SOUND_DATA_AREA_H */
